// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityBug.cpp
// Date           : February 2008
//
// Description    : This file defines the EntityBug class for the user's
//                  controllable avatar.  Once instantiated, the primary
//                  methods for control are Jump(), Run() and Drop().  The
//                  game loop (via CGame) must check IsDead() to determine
//                  if the player has died.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "entity.h"
#include "text.h"






class EntityThrownToken : public Entity 
{

  public:

    int                     m_BounceCount;


    EntityThrownToken();
    ~EntityThrownToken();


    virtual void            OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity );

    void                    UpdateTimed( Level& aLevel, float ElapsedTime );

    bool                    HasLanded() const;

};

